import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;

public class testEvent extends MIDlet 
       implements CommandListener {

  // Gestionnaire d'affichage
  Display display = null;
  // Menu d'lments
  List lstMenu = null;
  // Composant textbox
  TextBox tbxText = null;
  // Commandes retour, menu et sortie
  static final Command cmdRetour = new Command ("Retour", Command.BACK, 0);
  static final Command cmdMenu = new Command ("Menu", Command.SCREEN, 1);
  static final Command cmdSortie = new Command ("Sortie", Command.STOP, 2);

  /**
   *  Constructeur
  **/
  public testEvent() {
  }

  /**
   *  Lance le MIDlet.
   *  Cre une liste d'lments. Associe la commande Sortie  la liste.
  **/
  public void startApp() 
         throws MIDletStateChangeException {
    display = Display.getDisplay (this);
    // Cre le menu
    lstMenu = new List ("Menu", Choice.IMPLICIT);
    // Ajoute les lments dans le menu
    lstMenu.append ("Option 1", null);
    lstMenu.append ("Option 2", null);
    lstMenu.addCommand (cmdSortie);
    // Met en place le listener
    lstMenu.setCommandListener (this);
    mainMenu();
  }

  /**
   *  Suspend l'excution du MIDlet
  **/
  public void pauseApp() {
    display = null;
    lstMenu = null;
    tbxText = null;
  }

  /**
   *  Libre les ressources
  **/
  public void destroyApp (boolean unconditional) {
    notifyDestroyed();
  }

  /**
   *  Menu principal
  **/
  void mainMenu() {
    // Affiche le menu
    display.setCurrent (lstMenu);
  }

  /**
   *  Teste l'option 1
  **/
  public void testOption1() {
    // Affiche une zone de texte
    tbxText = new TextBox ("Entrez un texte: ", "", 5, TextField.ANY);
    tbxText.setString ("");
    // Ajoute une commande de retour
    tbxText.addCommand (cmdRetour);
    // Met en place le listener
    tbxText.setCommandListener (this);
    display.setCurrent (tbxText);
  }
   
  /**
   *  Teste l'option 2
  **/
  public void testOption2() {
    // Affiche une zone de texte
    tbxText = new TextBox ("Entrez un autre texte: ", "", 5, TextField.ANY);
    tbxText.setString ("");
    // Ajoute une commande de retour
    tbxText.addCommand (cmdRetour);
    // Met en place le listener
    tbxText.setCommandListener (this);
    display.setCurrent (tbxText);
  }

  /**
   *  Gre les vnements
  **/
  public void commandAction (Command cmdSelected, Displayable d) {
    String label = cmdSelected.getLabel();
    // Si la commande sortie est active, quitte le MIDlet.
    if (label.equals ("Sortie")) {
      destroyApp(true);
    } else if (label.equals("Retour")) {
      // Si la commande retour a t active, retourne au menu.
      // Retourne au menu
      mainMenu();
    } else {
      // Tous les autres cas correspondent  la slection d'un lment du menu.
      // On appele la mthode correspondante.
      List down = (List) display.getCurrent();
      switch (down.getSelectedIndex()) {
        case 0:
          testOption1();
          break;
        case 1:
          testOption2();
          break;
      }
    }
  }
}
